/*************** Help1 C Sample Program Source Code File (.C) *****************/
/*                                                                            */
/* PROGRAM NAME: Help1                                                        */
/* -------------                                                              */
/*  Presentation Manager Standard Window C Sample Program with Information    */
/*  Presentation Facility (IPF).                                              */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/*  (C) Copyright International Business Machines Corporation 1988            */
/*  Copyright (c) 1989 Microsoft Corporation                                  */
/*                                                                            */
/* REVISION LEVEL: 1.2                                                        */
/* ---------------                                                            */
/*                                                                            */
/* WHAT THIS PROGRAM DOES:                                                    */
/* -----------------------                                                    */
/*  This program displays a standard window containing the text "Help!".      */
/*  The action bar contains the choices Options and Help.                     */
/*  The Options pull-down contains four choices.  The first three choices     */
/*  replace the current window text with a numerical string (-1-.-2-,-3-)     */
/*  which corresponds to the pull-down option number.  The fourth choice      */
/*  exits the Help1 program.                                                  */
/*                                                                            */
/*  This program also includes code to incorporate the Information            */
/*  Presentation Facility (IPF).                                              */
/*  Help is provided for each of the choices on the action bar, as well       */
/*  as an overall help panel for the program.                                 */
/*  The help pull-down on the action bar provides Help for the IPF,           */
/*  a general (extended) help panel for the Help1 program, help on the IPF    */
/*  keys, and an index of all the help panels available.                      */
/*                                                                            */
/* WHAT THIS PROGRAM DEMONSTRATES:                                            */
/* -------------------------------                                            */
/*  This program illustrates how to create and display help panels in a       */
/*  standard window using the IPF.                                            */
/*                                                                            */
/* WHAT YOU NEED TO COMPILE THIS PROGRAM:                                     */
/* --------------------------------------                                     */
/*                                                                            */
/*  REQUIRED FILES:                                                           */
/*  ---------------                                                           */
/*                                                                            */
/*    **NOTE** : See Readme.C for a list and description of required          */
/*               SYSTEM files.                                                */
/*                                                                            */
/*    Help1.C       - Source code                                             */
/*    Help1.CMD     - Command File to build this Program                      */
/*    Help1.MAK     - Make File for this Program                              */
/*    Help1.DEF     - Module Definition File                                  */
/*    Help1.H       - Application Header File                                 */
/*    Help1.ICO     - Icon File                                               */
/*    Help1.L       - Linker Automatic Response File                          */
/*    Help1.RC      - Resource File                                           */
/*                                                                            */
/*    Help1.IPF     - Help Panel Definition File                              */
/*                                                                            */
/*    OS2.H         - Presentation Manager Include File                       */
/*    STRING.H      - String handling function declarations                   */
/*                                                                            */
/*    PMHELP.H      - IPF Include Files                                       */
/*                                                                            */
/*  REQUIRED LIBRARIES:                                                       */
/*  -------------------                                                       */
/*                                                                            */
/*    OS2.LIB        - Presentation Manager/OS2 library                       */
/*    SLIBCE.LIB     - Protect mode/standard combined small model C library   */
/*                                                                            */
/*  REQUIRED PROGRAMS:                                                        */
/*  ------------------                                                        */
/*                                                                            */
/*    IBM C Compiler                                                          */
/*    IBM Linker                                                              */
/*    Resource Compiler                                                       */
/*                                                                            */
/* EXPECTED INPUT:                                                            */
/* ---------------                                                            */
/*                                                                            */
/* EXPECTED OUTPUT:                                                           */
/* ----------------                                                           */
/*                                                                            */
/* CALLS USED (Dynamic Link References):                                      */
/* -------------------------------------                                      */
/*                                                                            */
/*    GpiCharStringAt     WinDefWindowProc    WinInvalidateRegion             */
/*    GpiSetBackColor     WinDestroyMsgQueue  WinLoadString                   */
/*    GpiSetBackMix       WinDestroyWindow    WinPostMsg                      */
/*    GpiSetColor         WinDispatchMsg      WinRegisterClass                */
/*    WinBeginPaint       WinEndPaint         WinSetWindowPos                 */
/*    WinCreateMsgQueue   WinGetMsg           WinTerminate                    */
/*    WinCreateStdWindow  WinInitialize       WinCreateHelpInstance           */
/*    WinAssociateHelpInstance                WinDestroyHelpInstance          */
/*                                                                            */
/******************************************************************************/

#define INCL_GPIPRIMITIVES              /* Selectively include       */
#define INCL_WINFRAMEMGR                /* relevant parts of         */
#define INCL_WINSYS                     /* the PM header file        */
#define INCL_WINHOOKS                   /* Hooks.                    */
 typedef struct ErrorMsgTable{
       unsigned long retcode;
       char     *    reason;
       } ErrorMsgTable ;

        /****************************************/
        /*  Include IPF Header File             */
        /*                                      */
        /* It is necessary to include the       */
        /* PMHELP.H file in any program which   */
        /* uses the Help Manager.  This file    */
        /* defines the structures used for HM   */
        /* initialization.                      */
        /****************************************/

#define INCL_WINHELP                    /* include IPF header file          */

#include <os2.h>                        /* PM header file                   */
#include <string.h>                     /* C/2 string functions             */
#include <stdio.h>                      /* C/2 sprint function.             */
#include "Help1.h"                     /* Resource symbolic identifiers    */

char errror_error[1024];
#define STRINGLENGTH 20                 /* Length of string                 */

/************************************************************************/
/* Function prototypes                                                  */
/************************************************************************/
MRESULT EXPENTRY MyWindowProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 );
void cdecl main( void );

                                        /* Define parameters by type    */
HAB  hab;                               /* PM anchor block handle       */
CHAR sz1[STRINGLENGTH];                 /* String parameters, set in    */
CHAR sz2[STRINGLENGTH];                 /* the processing of WM_CREATE, */
CHAR sz3[STRINGLENGTH];                 /* and used in the processing   */
CHAR sz4[STRINGLENGTH];                 /* of WM_COMMAND, in window     */
CHAR szString[STRINGLENGTH];            /* procedure.                   */


        /*************************************************/
        /* Required IPF Structure Declarations           */
        /*************************************************/

HELPINIT hmiHelpData;                   /* Help initialization structure*/
HWND     hwndHelpInstance;              /* Handle to Help window        */


/***************************************************************/
/*          HELP       Return Codes                            */
/***************************************************************/

  /* The help error table translates the number that is send in
   ulErrorCode to the text in the message. it is just a hack of
     PMHELP.H .
     I have left the form of it the same as pmhelp.h so you can see
     how I maded the help tables. It can be used with many others.
     Below is a copy of one of the pmhelp.h entrys i took.
                                       AVCruise. 7/22/92 */
/* Example follows. VVVVVVVVVV */
/******************************************************************************/
/* HMERR_NO_FRAME_WND_IN_CHAIN - There is no frame window in the              */
/* window chain from which to find or set the associated help                 */
/* instance.                                                                  */
/******************************************************************************/

/*
#define  HMERR_NO_FRAME_WND_IN_CHAIN                0x00001001L

 */
/* AAAAAAAAAAAAAAAAAAAAAAAAAA */

   ErrorMsgTable helperrortable[] = {
   0x00001001L,
 " HMERR_NO_FRAME_WND_IN_CHAIN - There is no frame window in the"
 " window chain from which to find or set the associated help"
 " instance."

 , 0x00001002L,
 " HMERR_INVALID_ASSOC_APP_WND - The application window handle"
 " specified on the WinAssociateHelpInstance() call is not a valid"
 " window handle."

 , 0x00001003L,
 " HMERR_INVALID_ASSOC_HELP_INST - The help instance handle specified"
 " on the WinAssociateHelpInstance() call is not a valid"
 " window handle."

 , 0x00001004L,
 " HMERR_INVALID_DESTROY_HELP_INST - The window handle specified"
 " as the help instance to destroy is not of the help instance class."

 , 0x00001005L,
 " HMERR_NO_HELP_INST_IN_CHAIN - The parent or owner chain of the"
 " application window specified does not have a help instance"
 " associated with it."

 , 0x00001006L,
 " HMERR_INVALID_HELP_INSTANCE_HDL - The handle specified to be a"
 " help instance does not have the class name of a IPF"
 " help instance."

 , 0x00001007L,
 " HMERR_INVALID_QUERY_APP_WND - The application window specified on"
 " a WinQueryHelpInstance() call is not a valid window handle."

 , 0x00001008L,
 " HMERR_HELP_INST_CALLED_INVALID -  The handle of the help instance"
 " specified on an API call to the IPF does not have the"
 " class name of an IPF help instance."

 , 0x00001009L,
 "  HMERR_HELPTABLE_UNDEFINE"
 " - The application did not provide a help table for"
 "context-sensitive help."

 , 0x0000100aL,
 "  HMERR_HELP_INSTANCE_UNDEFINE"
 " - The help instance handle specified is invalid."

 , 0x0000100bL,
 "  HMERR_HELPITEM_NOT_FOUND"
 " - Context-sensitive help was requested but the ID of the"
 " main help item specified was not found in the help table."

 , 0x0000100cL,
 "  HMERR_INVALID_HELPSUBITEM_SIZE"
 " - The help subtable item size is less than 2."

 , 0x0000100dL,
 "  HMERR_HELPSUBITEM_NOT_FOUND"
 " - Context-sensitive help was requested but the ID of the"
 " help item specified was not found in the help subtable."

 , 0x00002001L,
 " HMERR_INDEX_NOT_FOUND - No index in library file."

 , 0x00002002L,
 " HMERR_CONTENT_NOT_FOUND - Library file does not have any contents."

 , 0x00002003L,
 " HMERR_OPEN_LIB_FILE     - Cannot open library file."

 , 0x00002004L,
 " HMERR_READ_LIB_FILE     - Cannot read library file."

 , 0x00002005L,
 " HMERR_CLOSE_LIB_FILE    - Cannot close library file."

 , 0x00002006L,
 " HMERR_INVALID_LIB_FILE  - Improper library file provided."

 , 0x00002007L,
 " HMERR_NO_MEMORY - Unable to allocate the requested amount of memory."

 , 0x00002008L,
 " HMERR_ALLOCATE_SEGMENT - Unable"
 " to allocate a segment of memory for memory allocation requested"
 " from the IPF."

 , 0x00002009L,
 " HMERR_FREE_MEMORY - Unable to free allocated  memory."

 , 0x00002010L,
 " HMERR_PANEL_NOT_FOUND  - Unable"
 " to find a help panel requested to IPF."

 , 0x00002011L,
 " HMERR_DATABASE_NOT_OPEN - Unable to read the unopened database."
 ,9999,""    /* end marker (not perfect but good for examples.) */
};

/*****************************************************************/
/*****************************************************************/
static   USHORT usLastMode;
static   USHORT idTopicMenu,  idSubTopicMenu     = 0;
static   USHORT idTopicFrame, idSubTopicFrame    = 0;
static   USHORT idTopicWindow,idSubTopicWindow   = 0;

/*****************************************************************/
/* do a table search and if found return the text. if not found  */
/* return a string with the input value for error code.          */
/* All of the above tables have a end marker of 9999,""          */
/* so if can be used as the second parm to the "for",            */
/* rather then sizeof.                                           */
/*****************************************************************/
char * error_msg_table(ErrorMsgTable *errortable,
                       unsigned long  errorcode){
          int i;
          for (i=0;errortable[i].retcode!=9999 ; i++) {
             if (errortable[i].retcode == errorcode)
                 return errortable[i].reason;
          } /* endfor */
          sprintf(errror_error,"Error not Known. errorcode = <%x>."
                               ,errorcode);
          return errror_error;
       }


/*****************************************************************/
/* This routine has two uses.                                    */
/* Save the current help request.                                */
/* Display the help information if there is an help error.       */

/* I will discribe them in reverse order for ease of understanding.*/
/* 2nd is the help hook. We save the information about the       */
/* current request for help and then pass the request on.        */
/* There are 3 modes  (menu, frame, window) we can therefor      */
/* save the information in 3 sets of data.                       */
/*                                                               */
/* And 1st.                                                      */
/* If we have a help error,it call this same hook with a         */
/* Topic of 9991. IF we see the 9991 we put up a message         */
/* with the information that we got from the above routine.      */
/*                                                               */
/* NB. We return a False to say to help to keep looking.         */
/*****************************************************************/


BOOL EXPENTRY MyHelpHook(
                     HAB     hab
                    ,USHORT  usMode
                    ,USHORT  idTopic
                    ,USHORT  idSubTopic
                    ,PRECTL  prcPositon){
   /* Are we here for help on help errors. */
   if (idTopic ==  9991) {
                   /* This is the help for help Errors.  */
                   /* so we must show the mode, topic and subtopic */

          sprintf(errror_error,"Help Error Help \n"
                               "Last Mode Entry was [%s] <%d>\n"
                               "For Menu: \n"
                               " Last SubMenu      id was %u \n"
                               " Last item         id was %u.\n"
                               "For Frame: \n"
                               " Last frame        id was %u \n"
                               " Last focus-window id was %u.\n"
                               "For Window: \n"
                               " Last parent-window   was %u \n"
                               " Last focus-window id was %u.\n"
                               ,LastEntry[usLastMode]
                               ,usLastMode
                               ,idTopicMenu,idSubTopicMenu
                               ,idTopicFrame,idSubTopicFrame
                               ,idTopicWindow,idSubTopicWindow
                               );

        WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                     errror_error,
                     (PSZ) "Help Error Help",
                  9999,MB_OK
                     | MB_APPLMODAL
                      | MB_MOVEABLE);
         }; /* if (idTopic ==  9991)  */

  /* this is where we save the mode topic and subtopic */

    switch(usMode){
       case HLPM_MENU: {
            /* we have a menu item asking for help. save it.*/
          usLastMode     = 0     ;
          idTopicMenu    = idTopic;
          idSubTopicMenu = idSubTopic;
          break; }

       case HLPM_FRAME: {
            /* we have a menu item asking for help. save it.*/
          usLastMode      = 1;
          idTopicFrame    = idTopic;
          idSubTopicFrame = idSubTopic;
          break;   }

       case HLPM_WINDOW: {
            /* we have a Frame item asking for help. save it.*/
          usLastMode       = 2;
          idTopicWindow    = idTopic;
          idSubTopicWindow = idSubTopic;
          break;   }
}  /* switch usMode */

  /* this says to continue down the chain looking for help. */
   return FALSE;
};
/* And Now back to our original story.     AVC  */
/**********************  Start of main procedure  ***********************/
void cdecl main(  )
{
  HMQ  hmq;                             /* Message queue handle         */
  HWND hwndClient;                      /* Client area window handle    */
  HWND hwndFrame;                       /* Frame window handle          */
  QMSG qmsg;                            /* Message from message queue   */
  ULONG flCreate;                       /* Window creation control flags*/

  hab = WinInitialize( NULL );          /* Initialize PM                */
  hmq = WinCreateMsgQueue( hab, 0 );    /* Create a message queue       */

  WinRegisterClass(                     /* Register window class        */
     hab,                               /* Anchor block handle          */
     "MyWindow",                        /* Window class name            */
     MyWindowProc,                      /* Address of window procedure  */
     CS_SIZEREDRAW,                     /* Class Style                  */
     0                                  /* No extra window words        */
     );



   /*********************************************/
   /* IPF Initialization Structure              */
   /*********************************************/

                                          /* size of initialization structure*/
   hmiHelpData.cb                       = sizeof(HELPINIT);
                                          /* store HM return code from init. */
   hmiHelpData.ulReturnCode             = NULL;
                                          /* no tutorial program             */
   hmiHelpData.pszTutorialName          = NULL;
                                          /* indicates help table is defined */
                                          /* in the RC file.                 */
   hmiHelpData.phtHelpTable             = (PVOID)(0xffff0000 | MAIN_HELPTABLE);
                                          /* action bar is not tailored      */
   hmiHelpData.hmodAccelActionBarModule = NULL;
   hmiHelpData.idAccelTable             = NULL;
   hmiHelpData.idActionBar              = NULL;
                                          /* help window title               */
   hmiHelpData.pszHelpWindowTitle       = "Help1 Help Window";
                                          /* help table in not in a DLL      */
   hmiHelpData.hmodHelpTableModule      = NULL;
                                          /* help panels ID ARE    displayed */
     /* A must for debugging. AVCruise */
   hmiHelpData.usShowPanelId            = 1;   /* show the panelid AVCruise */


                                          /* library with help panels        */
   hmiHelpData.pszHelpLibraryName       = "Help1.HLP";


   /********************************************/
   /* Create Instance of IPF                   */
   /*                                          */
   /* pass Anchor Block handle and address of  */
   /* IPF initialization structure, and check  */
   /* that creation was successful.            */
   /********************************************/

   hwndHelpInstance = WinCreateHelpInstance(hab, &hmiHelpData);
   if (!hwndHelpInstance)
      {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                     (PSZ) "Help Not Available",
                     (PSZ) "Help Creation Error",
                     1,
                     MB_OK | MB_APPLMODAL | MB_MOVEABLE);
      }
   else
      {
      if (hmiHelpData.ulReturnCode)
         {
         WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                        (PSZ) "Help Terminated Due to Error",
                        (PSZ) "Help Creation Error",
                        1,
                        MB_OK | MB_APPLMODAL | MB_MOVEABLE);
         WinDestroyHelpInstance(hwndHelpInstance);
         }
      }

   flCreate = FCF_STANDARD &             /* Set Frame Control Flags to   */
              ~FCF_SHELLPOSITION;        /* standard except for shell    */
                                         /* positioning.                 */

   hwndFrame = WinCreateStdWindow(
               HWND_DESKTOP,            /* Desktop window is parent     */
               0L,                      /* No  frame styles             */
               &flCreate,               /* Frame control flag           */
               "MyWindow",              /* Client window class name     */
               "",                      /* No window text               */
               0L,                      /* No special class style       */
               NULL,                    /* Resource is in .EXE file     */
               ID_WINDOW,               /* Frame window identifier      */
               &hwndClient              /* Client window handle         */
               );

  WinSetWindowPos( hwndFrame,           /* Shows and activates frame    */
                   HWND_TOP,            /* window at position 50, 50,   */
                   50, 50, 250, 250,    /* and size 250, 250.           */
                   SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW
                 );

   /***************************************************/
   /* this is the BIG change to the help1 program. it
      asks to be called before the normal help stuff. */
   /***************************************************/
    WinSetHook(hab,hmq,HK_HELP,(PFN)MyHelpHook,(HMODULE)0);   /*AVC*/



   /********************************************/
   /* Associate Instance of IPF                */
   /*                                          */
   /* pass handle to Help Window and handle    */
   /* to frame window with which Help is       */
   /* to be associated.                        */
   /********************************************/

   if (hwndHelpInstance)
     {
     WinAssociateHelpInstance (hwndHelpInstance, hwndFrame);
     }

/************************************************************************/
/* Get and dispatch messages from the application message queue         */
/* until WinGetMsg returns FALSE, indicating a WM_QUIT message.         */
/************************************************************************/
  while( WinGetMsg( hab, &qmsg, NULL, 0, 0 ) )
    WinDispatchMsg( hab, &qmsg );

    /*****************************************/
    /* Destroy Instance of IPF               */
    /*                                       */
    /* on termination the active IPF         */
    /* instance should be destroyed.         */
    /*****************************************/

    if (hwndHelpInstance)
      {
      WinDestroyHelpInstance (hwndHelpInstance); /* Destroy Help Instance        */
      }

  WinDestroyWindow( hwndFrame );             /* Tidy up...                   */
  WinDestroyMsgQueue( hmq );                 /* and                          */
  WinTerminate( hab );                       /* terminate the application    */
}
/***********************  End of main procedure  ************************/




/*********************  Start of window procedure  **********************/
MRESULT EXPENTRY MyWindowProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
  USHORT command;                       /* WM_COMMAND command value     */
  HPS    hps;                           /* Presentation Space handle    */
  RECTL  rc;                            /* Rectangle coordinates        */
  POINTL pt;                            /* String screen coordinates    */

  switch( msg )
  {
    case WM_CREATE:
      /******************************************************************/
      /* Window initialization is performed here in WM_CREATE processing*/
      /* WinLoadString loads strings from resource file                 */
      /******************************************************************/
      WinLoadString( hab, NULL, IDS_1,     STRINGLENGTH, sz1 );
      WinLoadString( hab, NULL, IDS_2,     STRINGLENGTH, sz2 );
      WinLoadString( hab, NULL, IDS_3,     STRINGLENGTH, sz3 );
      WinLoadString( hab, NULL, IDS_4,     STRINGLENGTH, sz4 );
      strcpy( szString, sz1 );      /* Copy text into szString*/
      break;

    case WM_COMMAND:
      /******************************************************************/
      /* For the Commands pull down, when the user chooses option 1, 2, */
      /* or 3, the text string is set to 1, 2, or 3, and                */
      /* WinInvalidateRegion sends a WM_PAINT message.                  */
      /* For the Exit pull down, the application posts itself a WM_CLOSE*/
      /* message if Exit is chosen, or resumes if Resume is chosen.     */
      /******************************************************************/
      command = SHORT1FROMMP(mp1);      /* Extract the command value    */
      switch (command)
      {

          /*************************************************************/
          /* Help Display Utility                                      */
          /*                                                           */
          /* It is possible to modify this code to create a simple     */
          /* help panel display utility.  You can modify the options   */
          /* processing with the following code to display the help    */
          /* contents and help index.  It would also, be appropriate   */
          /* to add code to prompt for the help library name and use   */
          /* a HM_SET_HELP_LIBRARY_NAME message to pass this data      */
          /* to IPF.  By simply copying the help library you want to   */
          /* display to Help1.hlp you will have a help display utility */
          /*                                                           */
          /* case ID_OPTION1:                                          */
          /*   WinSendMsg(hwndHelpInstance,HM_HELP_CONTENTS, 0L, 0L);  */
          /*   break;                                                  */
          /* case ID_OPTION2:                                          */
          /*   WinSendMsg(hwndHelpInstance,HM_HELP_INDEX, 0L, 0L);     */
          /*   break;                                                  */
          /*                                                           */
          /*************************************************************/

        case ID_OPTION1:
          strcpy( szString, sz2 );
          WinInvalidateRegion( hwnd, NULL, FALSE );
          break;
        case ID_OPTION2:
          strcpy( szString, sz3 );
          WinInvalidateRegion( hwnd, NULL, FALSE );
          break;
        case ID_OPTION3:
          strcpy( szString, sz4 );
          WinInvalidateRegion( hwnd, NULL, FALSE );
          break;
        case ID_EXITPROG:
          WinPostMsg( hwnd, WM_CLOSE, 0L, 0L );
          break;

        /*****************************************************/
        /* DISPLAY HELP_FOR_HELP                             */
        /*                                                   */
        /* In order to display the system help for help panel*/
        /* send a HM_DISPLAY_HELP message to the help        */
        /* manager with 0L in both parameters                */
        /*****************************************************/

        case ID_HELP_FOR_HELP:
         if (hwndHelpInstance)
           {
            WinSendMsg( hwndHelpInstance, HM_DISPLAY_HELP, 0L, 0L);
           }
          break;

        default:
          return WinDefWindowProc( hwnd, msg, mp1, mp2 );
      }
      break;

      /**************************************************/
      /*     QUERY_KEYS_HELP                            */
      /*                                                */
      /* If the user requests KEYS HELP from the help   */
      /* pull-down, IPF sends the HM_QUERY_             */
      /* KEYS_HELP message to the application, which    */
      /* should return the panel id of the keys_help    */
      /* panel, or a 0 to tell IPF to do nothing.       */
      /**************************************************/

    case HM_QUERY_KEYS_HELP:
      return( (MRESULT) KEYS_HELP_PANEL_ID);
      break;

      /**************************************************/
      /*     HM_ERROR                                   */
      /*                                                */
      /* If an error occurs using IPF, an HM_ERROR msg  */
      /* will be sent to the application.  At this point*/
      /* you can display a message box and destroy the  */
      /* help instance.  This code can be replaced to   */
      /* perform the error processing which you desire. */
      /**************************************************/

    case HM_ERROR:
      if ( (hwndHelpInstance && (ULONG) mp1) == HMERR_NO_MEMORY)
        {
        WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                     (PSZ) "Help Terminated Due to Error",
                     (PSZ) "Help Error",
                     1,
                     MB_OK | MB_APPLMODAL | MB_MOVEABLE);
        WinDestroyHelpInstance(hwndHelpInstance);
        }
      else
        {

     /* This says call display the error and allow a MB_HELP action. */
     /* It will go to help with a ID of 9991. We trap this in        */
     /* MyHelpHook above and display the last entry information. AVC */

        WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
      // >>>>>>>>>   (PSZ) "Help Error Occurred",
                     (PSZ)  error_msg_table(helperrortable,(ULONG) mp1),
                     (PSZ) "Help Error",
                       9991,                    /*AVC */
                       MB_OK
                     | MB_HELP
                     | MB_APPLMODAL
                     | MB_MOVEABLE);
        }
      break;

    case WM_ERASEBACKGROUND:
      /******************************************************************/
      /* Return TRUE to request PM to paint the window background       */
      /* in SYSCLR_WINDOW.                                              */
      /******************************************************************/
      return (MRESULT)( TRUE );
    case WM_PAINT:
      /******************************************************************/
      /* Window contents are drawn here in WM_PAINT processing.         */
      /******************************************************************/
                                        /* Create a presentation space  */
      hps = WinBeginPaint( hwnd, NULL, &rc );
      pt.x = 50; pt.y = 50;             /* Set the text coordinates,    */
      GpiSetColor( hps, CLR_NEUTRAL );         /* colour of the text,   */
      GpiSetBackColor( hps, CLR_BACKGROUND );  /* its background and    */
      GpiSetBackMix( hps, BM_OVERPAINT );      /* how it mixes,         */
                                               /* and draw the string...*/
      GpiCharStringAt( hps, &pt, (LONG)strlen( szString ), szString );
      WinEndPaint( hps );                      /* Drawing is complete   */
      break;
    case WM_CLOSE:
      /******************************************************************/
      /* This is the place to put your termination routines             */
      /******************************************************************/
      WinPostMsg( hwnd, WM_QUIT, 0L, 0L );  /* Cause termination        */
      break;
    default:
      /******************************************************************/
      /* Everything else comes here.  This call MUST exist              */
      /* in your window procedure.                                      */
      /******************************************************************/

      return WinDefWindowProc( hwnd, msg, mp1, mp2 );
  }
  return FALSE;
}
/**********************  End of window procedure  ***********************/
